package gov.va.vinci.dart.db.impl;

import gov.va.vinci.dart.biz.Comment;
import gov.va.vinci.dart.biz.NestableComment;
import gov.va.vinci.dart.db.CommentDAO;
import gov.va.vinci.dart.db.NestableCommentDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

import java.util.List;

import javax.persistence.Query;

public class CommentDAOImpl extends HibernateDAO implements CommentDAO {
	
	@Override
	public Comment findById(final int commentId) {
//		return (Comment) findById(Comment.class, commentId);
		Query q = createQuery("from Comment where id=:cid");
		q.setParameter("cid", commentId);
		return (Comment)q.getSingleResult();
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<Comment> listByActivityId(final int activityId) {
		Query q = createQuery("from Comment where activity.id=:aid");
		q.setParameter("aid", activityId);
		return (List<Comment>)q.getResultList();
	}

	@Override
	// sorry about this being such ugly native SQL
	public List<NestableComment> listByRequestId(final int requestId) {
		return new NestableCommentDAO(requestId).build();
	}

	@Override
	public void save(Comment comment) {
		if (comment == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.save(comment);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Comment> listAll() {
		Query q = createQuery("from Comment");
		return (List<Comment>)q.getResultList();
	}

	@Override
	public void setPreviousComment(int commentId, int previousCommentId) {
		// Hibernate automatically handles this.
	}
}
